var banner = document.getElementById('banner');
var ctaAnimation = false;

var masterTimeline = new TimelineMax({paused:true, repeat:1, repeatDelay:2.5}),
tl1 = new TimelineMax();

//Timeline animation...
tl1.set(banner, {visibility: "visible"})
.add(function(){if(ctaAnimation){TweenMax.set(".cta, .cta_hover", {alpha:0})}})
.add(function(){ctaAnimation = false;})
.set(".cta_hover", {alpha:0, display:"none", visibility:"hidden"})

 /*frame one */  
.add("frame1")
.from(".gift1", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame1")
.from(".gift2", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame1-=.1")
.from(".gift3", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame1")
.from(".christmass", .5, {alpha:0, y:10, ease:Elastic.easeOut},"frame1+=.2")
.from(".sale", .3, {alpha:0, y:-10, ease:Elastic.easeOut},"frame1+=.3")
.from(".upto", .3, {alpha:0, y:-10, ease:Elastic.easeOut},"frame1+=.4")
.from(".price", .3, {alpha:0, y:-10, ease:Elastic.easeOut},"frame1+=.5")
.from(".enjoy", .3, {alpha:0, y:-10, ease:Elastic.easeOut},"frame1+=.5")
.to(".gift2,.gift1,.gift3,.grass", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame1+=3")
.from(".cap", .3, {y:-90, rotation:0.02, ease:Circ.easeOuteaseOut},"frame1+=3")

 /*frame two */   
.add("frame2","frame1+=3")
.from(".product1", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame2")
.from(".violator", .3, {scale:0, transformOrigin:"bottom right", rotation:0.02, ease:Sine.easeOut},"frame2+=.2")
.to(".product1, .violator", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame2+=3")

 /*frame three */   
.add("frame3","frame2+=3")
.from(".product2", .3, {y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame3")
.from(".violator2", .3, {scale:0, transformOrigin:"bottom right", rotation:0.02, ease:Sine.easeOut},"frame3+=.2")
.to(".enjoy", .3, {y:50, rotation:0.02, ease:Circ.easeOuteaseOut},"frame3+=2.5")
.from(".cta", .3, {alpha:0, y:250, rotation:0.02, ease:Circ.easeOuteaseOut},"frame3+=2.5")
.to('#replay', 0.2, {alpha:1, rotation: -360, onComplete:function(){ctaAnimation = true;}},"frame3+=2.5")
;

/*-------------------------------------
  Add all timelines to master timeline...
---------------------------------------*/
masterTimeline.add([tl1]);


banner.addEventListener("mouseover", function(){
  if(ctaAnimation){
    TweenMax.to(".cta", .5, {scale: 1.2,
        transformOrigin: "50% 50%", ease:Elastic.easeOut});
  
  }  
})

banner.addEventListener("mouseout", function(){
  if(ctaAnimation){

    TweenMax.to(".cta", .5, {scale: 1,
        transformOrigin: "50% 50%", ease:Elastic.easeOut});
  }  
})

/*-------------------------------------
  After window load...
---------------------------------------*/   
window.onload = function()
{
  masterTimeline.play();
}


/*-----------------------------------------
  Count animation duration of a timeline...
-----------------------------------------*/
var currentDuration = masterTimeline.totalDuration();
console.log(currentDuration); 

replay.addEventListener("click", function(){
  masterTimeline.restart();
})


