var banner = document.getElementById('banner');
var replay = document.getElementById('replay');

var masterTimeline = new TimelineMax({paused:true, repeat:0, repeatDelay:2}),
               tl1 = new TimelineMax();
               
/*---------------------------------------
  Timeline Animation
---------------------------------------*/  
tl1.set(banner, {visibility: "visible"})
   .from(".logo", .5, {alpha:0, ease:Sine.easeOut})
   .from(".frm1_txt1", .5, {alpha:0, y:15, rotation:0.02,  ease:Sine.easeOut}, "-=.25")
   .from(".frm1_txt2", .5, {alpha:0, y:15,  rotation:0.02, ease:Sine.easeOut})
    .to(".txt1", 1, { y:-155,  rotation:0.02, ease:Expo.easeInOut, delay:1})
   .from(".product", .5, {alpha:0, rotation:0.02, ease:Sine.easeInOut}, "-=.4")
   .from(".blurb", .8, {scale:.75, alpha:0, rotation:0.02, ease:Elastic.easeOut.config(1.5, .75)})
   .from(".blurb_txt", .5, {alpha:0, ease:Sine.easeOut}, "-=.6")
   .from(".cta", .75, { alpha:0,rotation:0.02, ease:Elastic.easeOut.config(.5, .5)})
   .from(".cta_txt", .5, {alpha:0, ease:Sine.easeOut}, "-=.35")
   .to('#replay', 0.4, {alpha:1, rotation: -360})
;




/*-------------------------------------
  Add all timelines to master timeline...
---------------------------------------*/
masterTimeline.add([tl1]);


/*-------------------------------------
  After window load...
---------------------------------------*/   
window.onload = function()
{
  masterTimeline.play();
}


replay.addEventListener("click", function(){
  masterTimeline.restart();
})


/*-----------------------------------------
  Count animation duration of a timeline...
-----------------------------------------*/
var currentDuration = masterTimeline.totalDuration();
console.log(currentDuration); 