var banner = document.getElementById('banner');
var masterTimeline = new TimelineMax({paused:true, repeat:0, repeatDelay:2}),
tl1 = new TimelineMax();

               
/*---------------------------------------
  Timeline Animation
---------------------------------------*/  
tl1.set(banner, {visibility: "visible"})  

/*frame one start*/	
.add("frame1")
.staggerFrom(".txt1,.txt2", .3, {alpha:0, y:30, rotation:0.02, ease:Quad.easeOut}, .2,"frame1")
.to(".txt1,.txt2, .product_frist", .5, {y:150, rotation:0.02, ease:Expo.easeIn}, "frame1+=2.2")


/*frame two start*/
.add("frame2","frame1+=2.3")
.from(".product_second, .product2_shadow", 1, {x:-550, y:-200, rotation:75, ease:Expo.easeInOut}, "frame2")
.add("frame2", 3.3)  
.to("#svg1,#svg2,#svg3,#svg4,#svg5,#svg6,#svg7,#svg8,#svg9,#svg10,#svg11,#svg12", .45, {alpha:1}, "frame2")
.add(createLineTween(svg1), "frame2")
.add(createLineTween(svg2), "frame2")
.add(createLineTween(svg3), "frame2")
.add(createLineTween(svg4), "frame2")
.add(createLineTween(svg5), "frame2")
.add(createLineTween(svg6), "frame2")
.add(createLineTween(svg7), "frame2")
.add(createLineTween(svg8), "frame2")
.add(createLineTween(svg9), "frame2")
.add(createLineTween(svg10), "frame2")
.add(createLineTween(svg11), "frame2")
.add(createLineTween(svg12), "frame2")
.from(".left_top_copy,.right_top_copy,.left_btm_copy,.right_btn_copy", .5, { alpha:0}, "frame2")
 .to(".product_second", 1, {y:-3, repeat:3, yoyo:true, rotation:0.02, ease:Sine.easeInOut}, "frame2+=1")
.to(".product2_shadow", 1, {y:3, repeat:3, yoyo:true, rotation:0.02, ease:Sine.easeInOut}, "frame2+=1")
.to(".product_second,.product2_shadow,#svg1,#svg2,#svg3,#svg4,#svg5,#svg6,#svg7,#svg8,#svg9,#svg10,#svg11,#svg12,.left_top_copy,.right_top_copy,.left_btm_copy,.right_btn_copy", .85, {scale:1.1, x:550, y:250, rotation:45, ease:Expo.easeInOut}, "frame2+=4.7")


/*frame Three start*/
.add("frame3","frame2+=4.9")
.from(".product_third", 1.5, {y:-200, rotation:0.02, ease:Elastic.easeInOut.config(1,.65)}, "frame3")
.from(".copy5b", 1.5, {y:200, rotation:0.02, ease:Elastic.easeInOut.config(1,.65)}, "frame3")
.from(".product_fifth,.copy5a", .75, {alpha:0, scale:.5, x:25, y:-15, transformOrigin:"top", rotation:-25, ease:Expo.easeInOut}, "frame3+=.75")
.from(".product_fourth,.copy5c", .75, {alpha:0, scale:.35, x:-30, ease:Expo.easeInOut}, "frame3+=.75")
.from(".copy3", .5, {x:280, rotation:0.02, ease:Quad.easeInOut}, "frame3+=1")
.from(".copy4", .5, {x:-210, rotation:0.02, ease:Quad.easeInOut}, "frame3+=1")
.from(".cta", .4, {alpha:0,  rotation:0.02, ease:Quad.easeInOut},"frame3+=1.3")  
.from(".cta_copy", .4, {alpha:0, rotation:0.02, ease:Sine.easeOut},"frame3+=1.3") 
.from(".cta_arrow", .4, {alpha:0, x:-5,  repeat:2,  rotation:0.02, ease:Sine.easeOut},"frame3+=1.5")
.to('#replay', 0.4, {alpha:1, rotation: -360},"frame3+=2")

;


//this function creates a single tween that animates the stroke of an svg
var tl = new TimelineMax({repeat:-1, yoyo:true});
function createLineTween(svg) { 
   var pathObject = {length:0, pathLength:svg.getTotalLength()}; 
   var tween = TweenLite.to(pathObject, .5, {length:pathObject.pathLength, onUpdate:drawLine, onUpdateParams:[pathObject, svg], immediateRender:true});
   return tween;
};
 //update stroke   
 function drawLine(obj, svg) {
  svg.style.strokeDasharray = [obj.length, obj.pathLength].join(' ');
 }; 

/*-------------------------------------
  Add all timelines to master timeline...
---------------------------------------*/
masterTimeline.add([tl1, tl]);

/*-------------------------------------
  After window load...
---------------------------------------*/   
window.onload = function(){
masterTimeline.play();

}

/*-----------------------------------------
  Count animation duration of a timeline...
-----------------------------------------*/
var currentDuration = tl1.totalDuration();
console.log(currentDuration); 

/*-----------------------------------------
  Replay of a timeline...
-----------------------------------------*/
replay.addEventListener("click", function(){
  masterTimeline.restart();
})
